﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.POSRetail.Controls.Loading;
using AZVIC.Ei8htPOS.POSRetail.Helpers;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace AZVIC.Ei8htPOS.POSRetail.Pages
{
    /// <summary>
    /// Interaction logic for LowStock.xaml
    /// </summary>
    public partial class LowStockReport : Page
    {
        public LowStockReport()
        {
            InitializeComponent();
            LoadReport();
        }


        private void btnSearch_Click(object sender, RoutedEventArgs e)
        {
            LoadReport(txtSearch.Text.Trim());
        }

        private void btnExport_Click(object sender, RoutedEventArgs e)
        {
            ExcelExportHelper.Export(gvLowStockReport, "LowStockReport");
        }

        private void LoadReport(string Keyword = "")
        {
            ProgressDialogResult result = ProgressDialog.Execute(Application.Current.MainWindow, string.Empty, (bw, we) =>
                 {
                     List<Products> pcList = ProductsBL.GetList(Guid.Empty, Keyword);
                     pcList = (from pb in pcList
                               where (pb.ActualStock + pb.ReserveStock) <= pb.LowStockIndication && pb.IsSales && pb.IsActive
                               orderby pb.ProductName ascending
                               select pb).ToList<Entities.Products>();
                     gvLowStockReport.Dispatcher.BeginInvoke(new Action(() => gvLowStockReport.ItemsSource = pcList));

                     if (pcList.Count == 0)
                         MessageBox.Show("No Products Found!", "Search Result", MessageBoxButton.OK, MessageBoxImage.Information);
                 });
        }
    }
}
